<?php
/***********************************

	Plugin Name:  One Click Demo Install
	Description:  Import Demo Content
	Version:      1.0
	Author:       Franklin Gitonga
	License:      GPLv2 or later
	Text Domain:  PixThemeCustom
	Domain Path:  /languages/

***********************************/

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// Don't duplicate me!
if ( !class_exists( 'Radium_Theme_Demo_Data_Importer' ) ) {

	require_once( dirname( __FILE__ ) . '/importer/radium-importer.php' ); //load admin theme data importer

	class Radium_Theme_Demo_Data_Importer extends Radium_Theme_Importer {

		/**
		 * Set framewok
		 *
		 * options that can be used are 'default', 'radium' or 'optiontree'
		 *
		 * @since 0.0.3
		 *
		 * @var string
		 */
		public $theme_options_framework = 'default';

		/**
		 * Holds a copy of the object for easy reference.
		 *
		 * @since 0.0.1
		 *
		 * @var object
		 */
		private static $instance;

		/**
		 * Set the key to be used to store theme options
		 *
		 * @since 0.0.2
		 *
		 * @var string
		 */
		public $theme_option_name       = 'pixtheme_options_name'; //set theme options name here (key used to save theme options). Optiontree option name will be set automatically

		/**
		 * Set name of the theme options file
		 *
		 * @since 0.0.2
		 *
		 * @var string
		 */
		public $theme_options_file_name = 'theme_options.txt';

		/**
		 * Set name of the widgets json file
		 *
		 * @since 0.0.2
		 *
		 * @var string
		 */
		public $widgets_file_name       = 'widgets.json';

		/**
		 * Set name of the content file
		 *
		 * @since 0.0.2
		 *
		 * @var string
		 */
		public $content_demo_file_name  = 'content.xml';

		/**
		 * Holds a copy of the widget settings
		 *
		 * @since 0.0.2
		 *
		 * @var string
		 */
		public $widget_import_results;

		/**
		 * Constructor. Hooks all interactions to initialize the class.
		 *
		 * @since 0.0.1
		 */
		public function __construct() {

			$this->demo_files_path = get_template_directory() . '/library/demo-files/'; //can

			self::$instance = $this;
			parent::__construct();

		}

		/**
		 * Add menus - the menus listed here largely depend on the ones registered in the theme
		 *
		 * @since 0.0.1
		 */
		public function set_demo_menus(){
			
			$menu_arr = array();
			
			// Menus to Import and assign - you can remove or add as many as you want
			$top_menu    = get_term_by('name', 'top', 'nav_menu');
			$main_menu   = get_term_by('name', 'main', 'nav_menu');
			$footer_menu = get_term_by('name', 'footer', 'nav_menu');
						
			
			if(is_object($top_menu))
				$menu_arr['top_nav'] = $top_menu->term_id;
			if(is_object($main_menu))
				$menu_arr['primary_nav'] = $main_menu->term_id;
			if(is_object($footer_menu))
				$menu_arr['footer_nav'] = $footer_menu->term_id;
			
			set_theme_mod( 'nav_menu_locations', $menu_arr );

			$this->flag_as_imported['menus'] = true;

		}

	}

	new Radium_Theme_Demo_Data_Importer;

}