<?php
if( ! defined( 'ABSPATH' ) ) 
	exit; // Exit if accessed directly

$auto_translate = unserialize( get_option( '_pixad_auto_translate' ) );

while ( $autozone_loop->have_posts() ) : $autozone_loop->the_post();
	$pixad_out .= '
	<article class="card clearfix" id="post-'.get_the_ID().'">
		<div class="card__img">';
			if( has_post_thumbnail() ):
				$pixad_out .= '<a href="'.get_the_permalink().'">
					'.get_the_post_thumbnail( get_the_ID(), 'autozone-auto-cat', array('class' => 'img-responsive')).'
				</a>';
			else:
				$pixad_out .= '<img class="no-image" src="'.PIXAD_AUTO_URI .'assets/img/no_image.jpg" alt="no-image">';
			endif;
			if( get_post_meta(get_the_ID(), 'pixad_auto_featured', true) ){
				$pixad_out .= '<span class="card__wrap-label"><span class="card__label">'.wp_kses_post($auto_translate[get_post_meta(get_the_ID(), 'pixad_auto_featured', true)]).'</span></span>';
			}
	$pixad_out .= '
		</div>
		<div class="card__inner">
			<h2 class="card__title ui-title-inner"><a href="'.get_the_permalink().'" title="'.esc_attr($strip_title).'">'.get_the_title().'</a></h2>
			<div class="decor-1"></div>
			<div class="card__description">
				<p>'.get_the_excerpt().'</p>
			</div>
			<!-- Car Details -->
			<ul class="card__list list-unstyled">';

			if( $validate['auto-fuel_show'] ):
			$pixad_out .= '
				<li class="card-list__row">
				  <span class="card-list__title">'.esc_html__( 'Fuel:', 'autozone' ).'</span>';

				  if( $this->get_meta('_auto_fuel') ):
					$pixad_out .= '<span class="card-list__info">'.wp_kses_post(( $auto_translate[$this->get_meta('_auto_fuel')] )).'</span>';
				  endif;
			$pixad_out .= '
				</li>';
			endif;

				if( $validate['auto-mileage_show'] ):
			$pixad_out .= '
				<li class="card-list__row"><!-- Mileage -->
				  <span class="card-list__title">'.esc_html__( 'Mileage:', 'autozone' ).'</span>';

				  if( $this->get_meta('_auto_mileage') ):
					$pixad_out .= '<span class="card-list__info">'.number_format($this->get_meta('_auto_mileage')).'</span>';
				  endif;
			$pixad_out .= '
				</li>';
				endif;

				if( $validate['auto-year_show'] ):
			$pixad_out .= '
				<li class="card-list__row">
				  <span class="card-list__title">'.esc_html__( 'Year:', 'autozone' ).'</span>';

				  if( $this->get_meta('_auto_year') ):
					$pixad_out .= '<span class="card-list__info">'.wp_kses_post($this->get_meta('_auto_year')).'</span>';
				  endif;
			$pixad_out .= '
				</li>';
				endif;

				if( $validate['auto-stock-status_show'] ):
			$pixad_out .= '
				<li class="card-list__row">
				  <span class="card-list__title">'.esc_html__( 'Stock Status:', 'autozone' ).'</span>';

				  if( $this->get_meta('_auto_stock_status') ):
					$pixad_out .= '<span class="card-list__info">'.wp_kses_post( $auto_translate[$this->get_meta('_auto_stock_status')] ).'</span>';
				  endif;
			$pixad_out .= '
				</li>';
				endif;

//				if( $validate['seller-country_show'] ):
//
//			$pixad_out .= '
//				<li class="card-list__row">
//				  <span class="card-list__title">'.esc_html__( 'Location:', 'autozone' ).'</span>';
//
//
////				  if( $this->get_meta('_seller_country') ):
////					$pixad_out .= '<span class="card-list__info">'.$country->text_output( $this->get_meta('_seller_country') ).'</span>';
////				  endif;
//			$pixad_out .= '
//				</li>';
//				endif;

				if( $validate['auto-condition_show'] && $this->get_meta('_auto_condition') ):
			$pixad_out .= '
					<li class="card-list__row">
						<span class="card-list__title">'.esc_html__( 'Condition:', 'autozone' ).'</span>';
					if( $this->get_meta('_auto_condition') == 'used' ):
						$pixad_out .= '<span class="card-list__info">'.esc_html__( 'Used', 'autozone' ).'</span>';
					elseif( $this->get_meta('_auto_condition') == 'new' ):
						$pixad_out .= '<span class="card-list__info">'.esc_html__( 'New', 'autozone' ).'</span>';
					else:
						$pixad_out .= '<span class="card-list__info">'.wp_kses_post( $auto_translate[$this->get_meta('_auto_condition')] ).'</span>';
					endif;
			$pixad_out .= '
					</li>';
				endif;

				if( $validate['auto-drive_show'] && $this->get_meta('_auto_drive') ):
			$pixad_out .= '
					<li class="card-list__row">
						<span class="card-list__title">'.esc_html__( 'Drive:', 'autozone' ).'</span>
						<span class="card-list__info">'.wp_kses_post( $auto_translate[$this->get_meta('_auto_drive')] ).'</span>
					</li>';
				endif;

				if( $validate['auto-engine_show'] && $this->get_meta('_autoesc_html_engine') ):
			$pixad_out .= '
					<li class="card-list__row">
						<span class="card-list__title">'.esc_html__( 'Engine:', 'autozone' ).'</span>
						<span class="card-list__info">'.wp_kses_post($this->get_meta('_autoesc_html_engine')).' '.esc_html__( 'cm3', 'autozone' ).'</span>
					</li>';
				endif;

				if( $validate['auto-horsepower_show'] && $this->get_meta('_auto_horsepower') ):
			$pixad_out .= '
					<li class="card-list__row">
						<span class="card-list__title">'.esc_html__( 'Horsepower:', 'autozone' ).'</span>
						<span class="card-list__info">'.wp_kses_post($this->get_meta('_auto_horsepower')).' '.esc_html__( 'hp', 'autozone' ).'</span>
					</li>';
				endif;

				if( $validate['auto-doors_show'] && $this->get_meta('_auto_doors') ):
			$pixad_out .= '
					<li class="card-list__row">
						<span class="card-list__title">'.esc_html__( 'Doors :', 'autozone' ).'</span>
						<span class="card-list__info">'.wp_kses_post($this->get_meta('_auto_doors')).' '.esc_html__( 'doors', 'autozone' ).'</span>
					</li>';
				endif;

				if( $validate['auto-date_show'] && get_the_date() ):
				$pixad_out .= '<li><span>'.get_the_date().'</span></li>';
				endif;

			$pixad_out .= '
			</ul><!-- / Car Details -->';

			if( $validate['auto-price_show'] ):
				$pixad_out .= '<div class="card__price">'.esc_html__( 'PRICE:' , 'autozone').'<span class="card__price-number">'.wp_kses_post($this->get_price()).'</span></div>';
			endif;

	$pixad_out .= '
		</div>

	</article>';
endwhile;

$pixad_out .= $this->pagenavi($autozone_loop->max_num_pages, $_REQUEST['paged']);

?>
